
USE BD_Air_France;

IF OBJECT_ID ('dbo.T_trace_trc','U') IS NOT NULL
    DROP TABLE dbo.T_trace_trc;
GO

IF OBJECT_ID ('dbo.T_compte_cpt','U') IS NOT NULL
    DROP TABLE dbo.T_compte_cpt;
GO

IF OBJECT_ID ('dbo.T_codevi_cdv','U') IS NOT NULL
    DROP TABLE dbo.T_codevi_cdv;
GO

CREATE TABLE T_codevi_cdv
(cli_num    VARCHAR(10),
 cdv_id     INT PRIMARY KEY,
 cdv_credit DECIMAL(10,2),
 cdv_debit  DECIMAL(10,2));
GO

CREATE TABLE T_compte_cpt
(cli_num    VARCHAR(10),
 cpt_id     INT PRIMARY KEY,
 cpt_credit DECIMAL(10,2),
 cpt_debit  DECIMAL(10,2));
GO

CREATE TABLE T_trace_trc
(trc_texte  VARCHAR(MAX));
GO

INSERT INTO T_codevi_cdv VALUES ('CLI34',128,800.90,500.65);
INSERT INTO T_compte_cpt VALUES ('CLI789',245,90.70,40.20);
GO

SELECT cdv_id,cdv_credit-cdv_debit AS solde,cdv_debit  FROM T_codevi_cdv;
SELECT cpt_id,cpt_credit-cpt_debit AS solde,cpt_credit  FROM T_compte_cpt;
SELECT * FROM T_trace_trc;

-- 325, 7-36

BEGIN
 DECLARE @montant    DECIMAL(8,2) = 3000.00,
        @solde       DECIMAL(10,2),
        @cpt_id_de   INT = 128,
        @cpt_id_vers INT = 245;
 BEGIN TRANSACTION transfert
 PRINT @@TRANCOUNT;
 BEGIN TRANSACTION tentative
  INSERT INTO T_trace_trc
    VALUES ('Compte  dbiter '+CAST(@cpt_id_de AS VARCHAR(10))+ 
            ' montant transfr : '+CAST(@montant AS VARCHAR(10))+
            ' date opration : '+CAST(GETDATE() AS VARCHAR(20)));
  SELECT @solde = cdv_credit-cdv_debit
         FROM T_codevi_cdv WHERE cdv_id = @cpt_id_de;
  PRINT @@TRANCOUNT;
  SAVE TRANSACTION avant;
  UPDATE T_codevi_cdv 
         SET   cdv_debit = cdv_debit  + @montant
         WHERE cdv_id    = @cpt_id_de;
  UPDATE T_compte_cpt 
         SET   cpt_credit = cpt_credit + @montant
         WHERE cpt_id     = @cpt_id_vers;
  IF (@solde >= @montant) 
     COMMIT TRANSACTION transfert;
  ELSE 
  BEGIN
   ROLLBACK TRANSACTION avant;
   PRINT 'aprs ROLLBACK TRANSACTION avant';
   PRINT @@TRANCOUNT;
   COMMIT TRANSACTION tentative;
   PRINT 'aprs COMMIT TRANSACTION tentative;';
   PRINT @@TRANCOUNT;
   THROW 50009,'Solde insuffisant',1;
   END;
   PRINT 'aprs IF';
  PRINT @@TRANCOUNT;
END;


SELECT cdv_id,cdv_credit-cdv_debit AS solde,cdv_debit  FROM T_codevi_cdv;
SELECT cpt_id,cpt_credit-cpt_debit AS solde,cpt_credit  FROM T_compte_cpt;
SELECT * FROM T_trace_trc;

-- 326

IF OBJECT_ID ('dbo.T_vols','U') IS NOT NULL
    DROP TABLE dbo.T_vols;
GO

IF OBJECT_ID ('dbo.T_passagers_pax','U') IS NOT NULL
    DROP TABLE dbo.T_passagers_pax;
GO

CREATE TABLE T_vols
(vol_num           VARCHAR(8),
 vol_datevol       DATE NOT NULL,
 vol_h_dep         TIME(0),
 vol_h_arr         TIME(0),
 vol_places_libres TINYINT,
 aer_dep           VARCHAR(3) NOT NULL,
 aer_arr           VARCHAR(3) NOT NULL,
 CONSTRAINT  PK_vlh  PRIMARY KEY(vol_num,vol_datevol));

CREATE TABLE T_passagers_pax
(vol_num           VARCHAR(8),
 vol_datevol       DATE NOT NULL,
 cli_code          VARCHAR(10) NOT NULL,
 pax_prix          DECIMAL(6,2));

--

DELETE FROM T_vols ;
DELETE FROM T_passagers_pax;

INSERT INTO T_vols 
VALUES('AF6140','20121228','18:15:00','19:45:00',50,'TLS','ORY');
INSERT INTO T_passagers_pax
VALUES('AF6140','20121228','Brouard',220.00);


-- 327, 7-38

-- READ UNCOMMITTED

-- fenetre 1

/*
DELETE FROM T_vols ;
INSERT INTO T_vols 
VALUES('AF6140','20121228','18:15:00','19:45:00',50,'TLS','ORY');
*/

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED 
BEGIN TRANSACTION transaction1;
 DECLARE @reste TINYINT,
         @resa  TINYINT = 7;
 SELECT  @reste = vol_places_libres FROM T_vols 
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol = CAST ('20121228' AS DATE);
 PRINT 'disponible : '+CAST((@reste) AS VARCHAR(3));
 UPDATE T_vols 
        SET vol_places_libres = @reste-@resa
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol = CAST ('20121228' AS DATE);
-- pendant ce temps autres rservations ailleurs
WAITFOR DELAY '00:00:05';
ROLLBACK TRANSACTION transaction1;

-- fenetre 2

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED 
BEGIN TRANSACTION transaction2;
 DECLARE @reste TINYINT,
         @resa  TINYINT = 15;
 SELECT  @reste = vol_places_libres FROM T_vols 
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol = CAST ('20121228' AS DATE);
PRINT 'disponible : '+CAST((@reste) AS VARCHAR(3));
 UPDATE T_vols 
        SET vol_places_libres = @reste-@resa
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol = CAST ('20121228' AS DATE);
 COMMIT TRANSACTION transaction2;

-- 328, 7-39

-- READ COMMITTED 

-- fenetre 1

/*
DELETE FROM T_vols ;
INSERT INTO T_vols 
VALUES('AF6140','20121228','18:15:00','19:45:00',50,'TLS','ORY');
*/

SET TRANSACTION ISOLATION LEVEL READ COMMITTED;
BEGIN TRANSACTION transaction1;
 DECLARE @reste TINYINT,
         @resa  TINYINT = 7;
 UPDATE T_vols 
        SET vol_places_libres = vol_places_libres-@resa
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol = CAST ('20121228' AS DATE);
--WAITFOR DELAY '00:00:10';
COMMIT TRANSACTION transaction1;

-- fenetre 2

SET TRANSACTION ISOLATION LEVEL READ COMMITTED;
BEGIN TRANSACTION transaction2; 
 DECLARE @reste TINYINT;
 SELECT  @reste = vol_places_libres FROM T_vols 
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol = CAST ('20121228' AS DATE);
 PRINT 'disponible : '+CAST((@reste) AS VARCHAR(3));
 WAITFOR DELAY '00:00:10';
 SELECT @reste =vol_places_libres FROM T_vols 
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol = CAST ('20121228' AS DATE);
 PRINT 'disponible : '+CAST((@reste) AS VARCHAR(3));
ROLLBACK TRANSACTION transaction2;

-- 328, 7-40

-- REPEATABLE READ

-- fenetre 1

/*
DELETE FROM T_vols ;
INSERT INTO T_vols 
VALUES('AF6140','20121228','18:15:00','19:45:00',50,'TLS','ORY');
*/

SET TRANSACTION ISOLATION LEVEL READ COMMITTED;
BEGIN TRANSACTION transaction1;
 DECLARE @resa  TINYINT = 7;
--WAITFOR DELAY '00:00:03';
 UPDATE T_vols 
        SET vol_places_libres = vol_places_libres-@resa
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol = CAST ('20121228' AS DATE);
COMMIT TRANSACTION transaction1;

-- fenetre 2

SET TRANSACTION ISOLATION LEVEL REPEATABLE READ;
BEGIN TRANSACTION transaction2;
 DECLARE @reste TINYINT;
 SELECT  @reste = vol_places_libres FROM T_vols 
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol = CAST ('20121228' AS DATE);
 PRINT 'disponible : '+CAST((@reste) AS VARCHAR(3));
 WAITFOR DELAY '00:00:04';
 SELECT @reste =vol_places_libres FROM T_vols 
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol = CAST ('20121228' AS DATE);
 PRINT 'disponible : '+CAST((@reste) AS VARCHAR(3));
ROLLBACK TRANSACTION transaction2;

-- 329, 7-41

-- Lecture fantome

/*
DELETE FROM T_vols ;
DELETE FROM T_passagers_pax;
INSERT INTO T_vols 
  VALUES('AF6140','20121228','18:15:00','19:45:00',50,'TLS','ORY');
INSERT INTO T_vols VALUES
  ('AF6144','20121228','19:55:00','20:45:00',50,'TLS','LYS');
INSERT INTO T_passagers_pax
  VALUES('AF6140','20121228','Brouard',220.00);
INSERT INTO T_passagers_pax
  VALUES('AF6140','20121228','Souquet',192.00);
*/

-- fenetre 1

BEGIN TRANSACTION transaction1;
 INSERT INTO T_passagers_pax
  VALUES('AF6144','20121228','Brouard',220.00);
 WAITFOR DELAY '00:00:10';
COMMIT TRANSACTION transaction1;


-- fenetre 2

SET TRANSACTION ISOLATION LEVEL REPEATABLE READ;
BEGIN TRANSACTION transaction2;
 DECLARE @nb_vol TINYINT;
 SELECT @nb_vol = COUNT(vol_num) FROM T_passagers_pax 
   WHERE cli_code='Brouard';
 PRINT 'nb  : '+CAST((@nb_vol) AS VARCHAR(3));
 WAITFOR DELAY '00:00:10';
 SELECT @nb_vol = COUNT(vol_num) FROM T_passagers_pax 
   WHERE cli_code='Brouard';
 PRINT 'nb  : '+CAST((@nb_vol) AS VARCHAR(3));
COMMIT TRANSACTION transaction2;

-- modes suprieurs

CREATE TABLE T_volants
(vol_nom   VARCHAR(30),
 vol_typ   VARCHAR(1) NOT NULL);

INSERT INTO T_volants VALUES('F-HCGA','A');
INSERT INTO T_volants VALUES('Brouard','P');
INSERT INTO T_volants VALUES('Bruchez','P');
INSERT INTO T_volants VALUES('F-HPPM','A');
INSERT INTO T_volants VALUES('Soutou','P');

-- 330, 7-42

-- fenetre 1

SET TRANSACTION ISOLATION LEVEL SNAPSHOT
BEGIN TRANSACTION transaction1;
 UPDATE T_volants 
  SET   vol_typ  = 'A' 
  WHERE vol_typ  = 'P';
 SELECT * FROM T_volants;
-- trans2
 WAITFOR DELAY '00:00:20';
COMMIT TRANSACTION transaction1;

SELECT * FROM T_volants;

-- fenetre 2

SET TRANSACTION ISOLATION LEVEL SNAPSHOT
BEGIN TRANSACTION transaction2;
 UPDATE T_volants 
  SET   vol_typ  = 'P' 
  WHERE vol_typ  = 'A';
COMMIT TRANSACTION transaction2;

-- 331, 7-43

-- deadlock

--fenetre 1

/*
DELETE FROM T_vols ;
INSERT INTO T_vols 
  VALUES('AF6140','20121228','18:15:00','19:45:00',50,'TLS','ORY');
INSERT INTO T_vols VALUES
  ('AF6144','20121228','19:55:00','20:45:00',50,'TLS','LYS');
*/

SET TRANSACTION ISOLATION LEVEL READ COMMITTED; 
BEGIN TRANSACTION transaction1;
 UPDATE T_vols 
        SET vol_places_libres = vol_places_libres-7
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol = CAST ('20121228' AS DATE);
-- pendant ce temps autres rservations ailleurs
 WAITFOR DELAY '00:00:05';
 UPDATE T_vols 
        SET vol_places_libres = vol_places_libres-4
        WHERE vol_num     = 'AF6144'
        AND   vol_datevol = CAST ('20121228' AS DATE);
COMMIT TRANSACTION transaction1;

-- fenetre 2

SET TRANSACTION ISOLATION LEVEL READ COMMITTED; 
BEGIN TRANSACTION transaction2;
 UPDATE T_vols 
        SET vol_places_libres = vol_places_libres-15
        WHERE vol_num     = 'AF6144'
        AND   vol_datevol = CAST ('20121228' AS DATE);
 WAITFOR DELAY '00:00:05';
 UPDATE T_vols 
        SET vol_places_libres = vol_places_libres-5
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol = CAST ('20121228' AS DATE);
 COMMIT TRANSACTION transaction2;

-- 333, locks

-- fenetre 1

/*
DELETE FROM T_vols ;
INSERT INTO T_vols 
  VALUES('AF6140','20121228','18:15:00','19:45:00',50,'TLS','ORY');
INSERT INTO T_vols VALUES
  ('AF6144','20121228','19:55:00','20:45:00',50,'TLS','LYS');
*/


SET TRANSACTION ISOLATION LEVEL REPEATABLE READ;
BEGIN TRANSACTION transaction1;
 SELECT vol_places_libres 
        FROM T_vols WITH (ROWLOCK, HOLDLOCK)
        WHERE vol_num     = 'AF6144'
        AND   vol_datevol = CAST ('20121228' AS DATE);
 UPDATE T_vols 
        SET vol_places_libres = vol_places_libres-7
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol = CAST ('20121228' AS DATE);
-- pendant ce temps autres rservations ailleurs
 WAITFOR DELAY '00:00:05';
 UPDATE T_vols 
        SET vol_places_libres = vol_places_libres-4
        WHERE vol_num     = 'AF6144'
        AND   vol_datevol = CAST ('20121228' AS DATE);
COMMIT TRANSACTION transaction1;

-- fenetre 2


SET TRANSACTION ISOLATION LEVEL REPEATABLE READ;
BEGIN TRANSACTION transaction2;
 UPDATE T_vols 
        SET vol_places_libres = vol_places_libres-15
        WHERE vol_num     = 'AF6144'
        AND   vol_datevol = CAST ('20121228' AS DATE);
 WAITFOR DELAY '00:00:05';
 UPDATE T_vols 
        SET vol_places_libres = vol_places_libres-5
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol = CAST ('20121228' AS DATE);
 COMMIT TRANSACTION transaction2;


IF OBJECT_ID ('dbo.T_volants','U') IS NOT NULL
    DROP TABLE dbo.T_volants;
GO

IF OBJECT_ID ('dbo.T_passagers_pax','U') IS NOT NULL
    DROP TABLE dbo.T_passagers_pax;
GO

IF OBJECT_ID ('dbo.T_vols','U') IS NOT NULL
    DROP TABLE dbo.T_vols;
GO

IF OBJECT_ID ('dbo.T_trace_trc','U') IS NOT NULL
    DROP TABLE dbo.T_trace_trc;
GO


IF OBJECT_ID ('dbo.T_compte_cpt','U') IS NOT NULL
    DROP TABLE dbo.T_compte_cpt;
GO

IF OBJECT_ID ('dbo.T_codevi_cdv','U') IS NOT NULL
    DROP TABLE dbo.T_codevi_cdv;
GO



